--------------------------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.all;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Entity configurable_u_lax_z80bus Is
  Port(
      CLK : in    std_logic;
      CLK_CAP : in    std_logic;
      EXT_TRIGGER : in    std_logic;
      N_RD : in   std_logic;
      N_WR : in   std_logic;
      Z80_A15 : in   std_logic;
      Z80_A14 : in   std_logic;
      Z80_A13 : in   std_logic;
      Z80_A12 : in   std_logic;
      Z80_A11 : in   std_logic;
      Z80_A10 : in   std_logic;
      Z80_A9 : in   std_logic;
      Z80_A8 : in   std_logic;
      Z80_A7 : in   std_logic;
      Z80_A6 : in   std_logic;
      Z80_A5 : in   std_logic;
      Z80_A4 : in   std_logic;
      Z80_A3 : in   std_logic;
      Z80_A2 : in   std_logic;
      Z80_A1 : in   std_logic;
      Z80_A0 : in   std_logic;
      DIN7 : in   std_logic;
      DIN6 : in   std_logic;
      DIN5 : in   std_logic;
      DIN4 : in   std_logic;
      DIN3 : in   std_logic;
      DIN2 : in   std_logic;
      DIN1 : in   std_logic;
      DIN0 : in   std_logic;
      DOUT7 : in   std_logic;
      DOUT6 : in   std_logic;
      DOUT5 : in   std_logic;
      DOUT4 : in   std_logic;
      DOUT3 : in   std_logic;
      DOUT2 : in   std_logic;
      DOUT1 : in   std_logic;
      DOUT0 : in   std_logic;
      Set0_Spare : in   std_logic_vector(29 downto 0);
      STATUS : out   std_logic;
      TCK : in   std_logic;
      TDI : in   std_logic;
      TDO : out   std_logic;
      TMS : in   std_logic;
      TRST : in   std_logic
      );
End configurable_u_lax_z80bus;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Architecture structure of configurable_u_lax_z80bus is

   Component LAX_CFG64
      port
      (
        CH_TRIG  : in  STD_LOGIC_VECTOR(63 downto 0);
        CH_CAP   : in  STD_LOGIC_VECTOR(63 downto 0);
        CLK      : in  STD_LOGIC;
        CLK_CAP  : in  STD_LOGIC;
        STATUS   : out STD_LOGIC;
        DATAO    : out STD_LOGIC_VECTOR(63 downto 0);
        DATAI    : in  STD_LOGIC_VECTOR(63 downto 0);
        ADDR     : out STD_LOGIC_VECTOR(19 downto 0);
        WR       : out STD_LOGIC;
        RD       : out STD_LOGIC;
        SEL_CAP  : out STD_LOGIC_VECTOR(3 downto 0);
        SEL_TRIG : out STD_LOGIC_VECTOR(3 downto 0);
        TCK      : in  STD_LOGIC;
        TDI      : in  STD_LOGIC;
        TDO      : out STD_LOGIC;
        TMS      : in  STD_LOGIC;
        TRIGGER  : in  STD_LOGIC;
        TRST     : in  STD_LOGIC
      );
   End Component;

   Component memory_u_lax_z80bus
      port
      (
        CLK      : in  STD_LOGIC;
        WE       : in  STD_LOGIC;
        ADDR     : in  STD_LOGIC_VECTOR(9 downto 0);
        DIN      : in  STD_LOGIC_VECTOR(63 downto 0);
        DOUT     : out STD_LOGIC_VECTOR(63 downto 0)
      );
   End Component;

   Signal Unique_Lax_Signal_Name_Mem_WE   : STD_LOGIC;
   Signal Unique_Lax_Signal_Name_Mem_DIN  : STD_LOGIC_VECTOR(63 downto 0);
   Signal Unique_Lax_Signal_Name_Mem_DOUT : STD_LOGIC_VECTOR(63 downto 0);

   Signal Unique_Lax_Signal_Name_Mem_ADDR : STD_LOGIC_VECTOR(19 Downto 0);
   Signal Unique_Lax_Signal_Name_selcap   : STD_LOGIC_VECTOR(3 downto 0);
   Signal Unique_Lax_Signal_Name_seltrig  : STD_LOGIC_VECTOR(3 downto 0);
   Signal Unique_Lax_Signal_Name_capin    : STD_LOGIC_VECTOR(63 downto 0);
   Signal Unique_Lax_Signal_Name_trigin   : STD_LOGIC_VECTOR(63 downto 0);


Begin
    Unique_Lax_Signal_Name_capin(0) <= N_RD;
    Unique_Lax_Signal_Name_trigin(0) <= N_RD;
    Unique_Lax_Signal_Name_capin(1) <= N_WR;
    Unique_Lax_Signal_Name_trigin(1) <= N_WR;
    Unique_Lax_Signal_Name_capin(2) <= Z80_A15;
    Unique_Lax_Signal_Name_trigin(2) <= Z80_A15;
    Unique_Lax_Signal_Name_capin(3) <= Z80_A14;
    Unique_Lax_Signal_Name_trigin(3) <= Z80_A14;
    Unique_Lax_Signal_Name_capin(4) <= Z80_A13;
    Unique_Lax_Signal_Name_trigin(4) <= Z80_A13;
    Unique_Lax_Signal_Name_capin(5) <= Z80_A12;
    Unique_Lax_Signal_Name_trigin(5) <= Z80_A12;
    Unique_Lax_Signal_Name_capin(6) <= Z80_A11;
    Unique_Lax_Signal_Name_trigin(6) <= Z80_A11;
    Unique_Lax_Signal_Name_capin(7) <= Z80_A10;
    Unique_Lax_Signal_Name_trigin(7) <= Z80_A10;
    Unique_Lax_Signal_Name_capin(8) <= Z80_A9;
    Unique_Lax_Signal_Name_trigin(8) <= Z80_A9;
    Unique_Lax_Signal_Name_capin(9) <= Z80_A8;
    Unique_Lax_Signal_Name_trigin(9) <= Z80_A8;
    Unique_Lax_Signal_Name_capin(10) <= Z80_A7;
    Unique_Lax_Signal_Name_trigin(10) <= Z80_A7;
    Unique_Lax_Signal_Name_capin(11) <= Z80_A6;
    Unique_Lax_Signal_Name_trigin(11) <= Z80_A6;
    Unique_Lax_Signal_Name_capin(12) <= Z80_A5;
    Unique_Lax_Signal_Name_trigin(12) <= Z80_A5;
    Unique_Lax_Signal_Name_capin(13) <= Z80_A4;
    Unique_Lax_Signal_Name_trigin(13) <= Z80_A4;
    Unique_Lax_Signal_Name_capin(14) <= Z80_A3;
    Unique_Lax_Signal_Name_trigin(14) <= Z80_A3;
    Unique_Lax_Signal_Name_capin(15) <= Z80_A2;
    Unique_Lax_Signal_Name_trigin(15) <= Z80_A2;
    Unique_Lax_Signal_Name_capin(16) <= Z80_A1;
    Unique_Lax_Signal_Name_trigin(16) <= Z80_A1;
    Unique_Lax_Signal_Name_capin(17) <= Z80_A0;
    Unique_Lax_Signal_Name_trigin(17) <= Z80_A0;
    Unique_Lax_Signal_Name_capin(18) <= DIN7;
    Unique_Lax_Signal_Name_trigin(18) <= DIN7;
    Unique_Lax_Signal_Name_capin(19) <= DIN6;
    Unique_Lax_Signal_Name_trigin(19) <= DIN6;
    Unique_Lax_Signal_Name_capin(20) <= DIN5;
    Unique_Lax_Signal_Name_trigin(20) <= DIN5;
    Unique_Lax_Signal_Name_capin(21) <= DIN4;
    Unique_Lax_Signal_Name_trigin(21) <= DIN4;
    Unique_Lax_Signal_Name_capin(22) <= DIN3;
    Unique_Lax_Signal_Name_trigin(22) <= DIN3;
    Unique_Lax_Signal_Name_capin(23) <= DIN2;
    Unique_Lax_Signal_Name_trigin(23) <= DIN2;
    Unique_Lax_Signal_Name_capin(24) <= DIN1;
    Unique_Lax_Signal_Name_trigin(24) <= DIN1;
    Unique_Lax_Signal_Name_capin(25) <= DIN0;
    Unique_Lax_Signal_Name_trigin(25) <= DIN0;
    Unique_Lax_Signal_Name_capin(26) <= DOUT7;
    Unique_Lax_Signal_Name_trigin(26) <= DOUT7;
    Unique_Lax_Signal_Name_capin(27) <= DOUT6;
    Unique_Lax_Signal_Name_trigin(27) <= DOUT6;
    Unique_Lax_Signal_Name_capin(28) <= DOUT5;
    Unique_Lax_Signal_Name_trigin(28) <= DOUT5;
    Unique_Lax_Signal_Name_capin(29) <= DOUT4;
    Unique_Lax_Signal_Name_trigin(29) <= DOUT4;
    Unique_Lax_Signal_Name_capin(30) <= DOUT3;
    Unique_Lax_Signal_Name_trigin(30) <= DOUT3;
    Unique_Lax_Signal_Name_capin(31) <= DOUT2;
    Unique_Lax_Signal_Name_trigin(31) <= DOUT2;
    Unique_Lax_Signal_Name_capin(32) <= DOUT1;
    Unique_Lax_Signal_Name_trigin(32) <= DOUT1;
    Unique_Lax_Signal_Name_capin(33) <= DOUT0;
    Unique_Lax_Signal_Name_trigin(33) <= DOUT0;
    Unique_Lax_Signal_Name_capin(34) <= Set0_Spare(0);
    Unique_Lax_Signal_Name_trigin(34) <= Set0_Spare(0);
    Unique_Lax_Signal_Name_capin(35) <= Set0_Spare(1);
    Unique_Lax_Signal_Name_trigin(35) <= Set0_Spare(1);
    Unique_Lax_Signal_Name_capin(36) <= Set0_Spare(2);
    Unique_Lax_Signal_Name_trigin(36) <= Set0_Spare(2);
    Unique_Lax_Signal_Name_capin(37) <= Set0_Spare(3);
    Unique_Lax_Signal_Name_trigin(37) <= Set0_Spare(3);
    Unique_Lax_Signal_Name_capin(38) <= Set0_Spare(4);
    Unique_Lax_Signal_Name_trigin(38) <= Set0_Spare(4);
    Unique_Lax_Signal_Name_capin(39) <= Set0_Spare(5);
    Unique_Lax_Signal_Name_trigin(39) <= Set0_Spare(5);
    Unique_Lax_Signal_Name_capin(40) <= Set0_Spare(6);
    Unique_Lax_Signal_Name_trigin(40) <= Set0_Spare(6);
    Unique_Lax_Signal_Name_capin(41) <= Set0_Spare(7);
    Unique_Lax_Signal_Name_trigin(41) <= Set0_Spare(7);
    Unique_Lax_Signal_Name_capin(42) <= Set0_Spare(8);
    Unique_Lax_Signal_Name_trigin(42) <= Set0_Spare(8);
    Unique_Lax_Signal_Name_capin(43) <= Set0_Spare(9);
    Unique_Lax_Signal_Name_trigin(43) <= Set0_Spare(9);
    Unique_Lax_Signal_Name_capin(44) <= Set0_Spare(10);
    Unique_Lax_Signal_Name_trigin(44) <= Set0_Spare(10);
    Unique_Lax_Signal_Name_capin(45) <= Set0_Spare(11);
    Unique_Lax_Signal_Name_trigin(45) <= Set0_Spare(11);
    Unique_Lax_Signal_Name_capin(46) <= Set0_Spare(12);
    Unique_Lax_Signal_Name_trigin(46) <= Set0_Spare(12);
    Unique_Lax_Signal_Name_capin(47) <= Set0_Spare(13);
    Unique_Lax_Signal_Name_trigin(47) <= Set0_Spare(13);
    Unique_Lax_Signal_Name_capin(48) <= Set0_Spare(14);
    Unique_Lax_Signal_Name_trigin(48) <= Set0_Spare(14);
    Unique_Lax_Signal_Name_capin(49) <= Set0_Spare(15);
    Unique_Lax_Signal_Name_trigin(49) <= Set0_Spare(15);
    Unique_Lax_Signal_Name_capin(50) <= Set0_Spare(16);
    Unique_Lax_Signal_Name_trigin(50) <= Set0_Spare(16);
    Unique_Lax_Signal_Name_capin(51) <= Set0_Spare(17);
    Unique_Lax_Signal_Name_trigin(51) <= Set0_Spare(17);
    Unique_Lax_Signal_Name_capin(52) <= Set0_Spare(18);
    Unique_Lax_Signal_Name_trigin(52) <= Set0_Spare(18);
    Unique_Lax_Signal_Name_capin(53) <= Set0_Spare(19);
    Unique_Lax_Signal_Name_trigin(53) <= Set0_Spare(19);
    Unique_Lax_Signal_Name_capin(54) <= Set0_Spare(20);
    Unique_Lax_Signal_Name_trigin(54) <= Set0_Spare(20);
    Unique_Lax_Signal_Name_capin(55) <= Set0_Spare(21);
    Unique_Lax_Signal_Name_trigin(55) <= Set0_Spare(21);
    Unique_Lax_Signal_Name_capin(56) <= Set0_Spare(22);
    Unique_Lax_Signal_Name_trigin(56) <= Set0_Spare(22);
    Unique_Lax_Signal_Name_capin(57) <= Set0_Spare(23);
    Unique_Lax_Signal_Name_trigin(57) <= Set0_Spare(23);
    Unique_Lax_Signal_Name_capin(58) <= Set0_Spare(24);
    Unique_Lax_Signal_Name_trigin(58) <= Set0_Spare(24);
    Unique_Lax_Signal_Name_capin(59) <= Set0_Spare(25);
    Unique_Lax_Signal_Name_trigin(59) <= Set0_Spare(25);
    Unique_Lax_Signal_Name_capin(60) <= Set0_Spare(26);
    Unique_Lax_Signal_Name_trigin(60) <= Set0_Spare(26);
    Unique_Lax_Signal_Name_capin(61) <= Set0_Spare(27);
    Unique_Lax_Signal_Name_trigin(61) <= Set0_Spare(27);
    Unique_Lax_Signal_Name_capin(62) <= Set0_Spare(28);
    Unique_Lax_Signal_Name_trigin(62) <= Set0_Spare(28);
    Unique_Lax_Signal_Name_capin(63) <= Set0_Spare(29);
    Unique_Lax_Signal_Name_trigin(63) <= Set0_Spare(29);

    U1 : LAX_CFG64
      Port Map
      (
        CH_CAP    => Unique_Lax_Signal_Name_capin,
        CH_TRIG   => Unique_Lax_Signal_Name_trigin,
        CLK      => CLK,
        CLK_CAP  => CLK_CAP,
        STATUS   => STATUS,
        DATAO    => Unique_Lax_Signal_Name_Mem_DIN,
        DATAI    => Unique_Lax_Signal_Name_Mem_DOUT,
        WR       => Unique_Lax_Signal_Name_Mem_WE,
        RD       => Open,
        ADDR     => Unique_Lax_Signal_Name_Mem_ADDR,
        SEL_CAP  => Unique_Lax_Signal_Name_selcap,
        SEL_TRIG => Unique_Lax_Signal_Name_seltrig,
        TCK      => TCK,
        TDI      => TDI,
        TDO      => TDO,
        TMS      => TMS,
        TRIGGER  => EXT_TRIGGER,
        TRST     => TRST
      );
    U2 : memory_u_lax_z80bus
      Port Map
      (
        CLK      => CLK,
        DIN      => Unique_Lax_Signal_Name_Mem_DIN,
        DOUT     => Unique_Lax_Signal_Name_Mem_DOUT,
        ADDR     => Unique_Lax_Signal_Name_Mem_ADDR(9 Downto 0),
        WE       => Unique_Lax_Signal_Name_Mem_WE
      );

End structure;
--------------------------------------------------------------------------------
